var app = angular.module('eBillingPortal', ['ngAnimate', 'ngRoute', 'ui.bootstrap', 'ngSanitize', 'ui.grid', 'ui.grid.selection', 'ui.grid.cellNav', 'ui.grid.edit']);
app.controller('allinvoiceList', ['$scope', '$http', '$templateCache', '$uibModal', '$log', '$timeout', function ($scope, $http, $templateCache, $uibModal, $log, $timeout) {
    $scope.url = "/CommonPages/Invoice/";

    $scope.pageLoadDetails = function () {
        $http({ method: 'POST', url: $scope.url + 'pageLoadDetailsInvoiceList', cache: $templateCache }).then(successCallback, errorCallback);
    };
    function successCallback(response) {
        $scope.gridOwnOrderlst.data = response.data.ownlst;
        $scope.gridOtherOrderlst.data = response.data.otherlst;
        $scope.gridPendingInvoiceOrderlst.data = response.data.pendinglst;
    }
    function errorCallback(error) { }

    $scope.gridOwnOrderlst = {
        enableRowSelection: false,
        enableSelectAll: false,
        enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        paginationPageSizes: [10, 15, 20],
        paginationPageSize: 10,
        enableFiltering: true
    };
    var actionTemplate = '<div class="ui-grid-cell-contents"><button type="button" class="btn btn-sm btn-link" ng-click="grid.appScope.printinvoicedetails(row.entity)">Print Invoice</button></div>';
    $scope.gridOwnOrderlst.columnDefs = [        
        { name: 'invoiceid', displayName: 'Invoice', width: 90},        
        { name: 'orderid', displayName: 'Order ID' },
        { name: 'customerid', displayName: 'Customer ID' },
        { name: 'customername', displayName: 'Name' },
        { name: 'customermobile', displayName: 'Mobile' },
        { name: 'invoiceamount', displayName: 'Amount', width: 90 },
        { name: 'netamount', displayName: 'Net Amount', width: 90 },
        { field: 'e', displayName: 'Action', cellTemplate: actionTemplate }
    ];
    $scope.gridOwnOrderlst.multiSelect = false;
    $scope.gridOwnOrderlst.onRegisterApi = function (gridApi) { };

    $scope.gridOtherOrderlst = {
        enableRowSelection: false,
        enableSelectAll: false,
        enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        paginationPageSizes: [10, 15, 20],
        paginationPageSize: 10,
        enableFiltering: true
    };
    $scope.gridOtherOrderlst.columnDefs = [
        { name: 'invoiceid', displayName: 'Invoice', width: 90 },
        { name: 'orderid', displayName: 'Order ID' },
        { name: 'customerid', displayName: 'Customer ID' },
        { name: 'customername', displayName: 'Name' },
        { name: 'customermobile', displayName: 'Mobile' },
        { name: 'invoiceamount', displayName: 'Amount', width: 90 },
        { name: 'netamount', displayName: 'Net Amount', width: 90 },
       // { name: 'username', displayName: 'By' },
        { field: 'e', displayName: 'Action', cellTemplate: actionTemplate }
    ];
    $scope.gridOtherOrderlst.multiSelect = false;
    $scope.gridOtherOrderlst.onRegisterApi = function (gridApi) { };

    $scope.gridPendingInvoiceOrderlst = {
        enableRowSelection: false,
        enableSelectAll: false,
        enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        paginationPageSizes: [10, 15, 20],
        paginationPageSize: 10,
        enableFiltering: true
    };
    $scope.gridPendingInvoiceOrderlst.columnDefs = [       
        { name: 'orderid', displayName: 'Order ID' },
        { name: 'customerid', displayName: 'Customer ID' },
        { name: 'customername', displayName: 'Name' },
        { name: 'customermobile', displayName: 'Mobile' },
        { name: 'invoiceamount', displayName: 'Amount', width: 90},
        { name: 'netamount', displayName: 'Net Amount', width: 90},
        { name: 'username', displayName: 'By' },
        { field: 'e', displayName: 'Action', cellTemplate: "" }
    ];
    $scope.gridPendingInvoiceOrderlst.multiSelect = false;
    $scope.gridPendingInvoiceOrderlst.onRegisterApi = function (gridApi) { };

    $scope.printinvoicedetails = function (row) {
       // var strURL = "/CommonPages/Billing/PrintInvoice?orderID=" + row.orderid;
        var strURL = "/CommonPages/Billing/PrintInvoice/" + row.orderid;
        window.open(strURL, "print");
    };
    $scope.pageLoadDetails();
     
}]);
